<?php

namespace XF\ControllerPlugin;

use XF\Mvc\Entity\Entity;
use XF\Repository\ModeratorLogRepository;

use function count, is_array;

class ModeratorLogPlugin extends AbstractPlugin
{
	public function actionModeratorActions(Entity $entity, array $linkData, $title = null, array $breadcrumbs = [])
	{
		$contentType = $entity->getEntityContentType();
		$contentId = $entity->getEntityId();

		if (!$contentType)
		{
			throw new \InvalidArgumentException("Provided entity must defined a content type in its structure");
		}

		$modLogRepo = $this->repository(ModeratorLogRepository::class);

		$page = $this->filterPage();
		$perPage = 20;

		$logs = $modLogRepo->findLogsForDiscussion($contentType, $contentId)
			->limitByPage($page, $perPage, 1)
			->fetch();

		if (!count($logs))
		{
			return $this->message(\XF::phrase('no_moderator_actions_have_been_logged'));
		}

		$hasNext = count($logs) > $perPage;
		$logs = $logs->slice(0, $perPage);

		$viewParams = [
			'type' => $contentType,
			'id' => $contentId,

			'linkRoute' => $linkData[0] ?? '',
			'linkData' => $linkData[1] ?? null,
			'linkParams' => (isset($linkData[2]) && is_array($linkData[2])) ? $linkData[2] : [],

			'logs' => $logs,
			'hasNext' => $hasNext,
			'page' => $page,

			'title' => $title,
			'breadcrumbs' => $breadcrumbs,
		];
		return $this->view('XF:ModeratorLog\ModeratorActions', 'moderator_log_moderator_actions', $viewParams);
	}
}
