<?php

namespace XF\Entity;

use XF\Mvc\Entity\Entity;
use XF\Mvc\Entity\Structure;

/**
 * COLUMNS
 * @property int $thread_id
 * @property string $field_id
 * @property string $field_value
 */
class ThreadFieldValue extends Entity
{
	public static function getStructure(Structure $structure)
	{
		$structure->table = 'xf_thread_field_value';
		$structure->shortName = 'XF:ThreadFieldValue';
		$structure->primaryKey = ['thread_id', 'field_id'];
		$structure->columns = [
			'thread_id' => ['type' => self::UINT, 'required' => true],
			'field_id' => ['type' => self::STR, 'maxLength' => 25,
				'match' => self::MATCH_ALPHANUMERIC,
			],
			'field_value' => ['type' => self::STR, 'default' => ''],
		];
		$structure->getters = [];
		$structure->relations = [];

		return $structure;
	}
}
